// ========================
// TAB SWITCHING
// ========================
const tabs = document.querySelectorAll(".tab");
const contents = document.querySelectorAll(".content");

tabs.forEach((tab) => {
  tab.addEventListener("click", () => {
    tabs.forEach((t) => t.classList.remove("active"));
    contents.forEach((c) => c.classList.remove("active"));
    tab.classList.add("active");
    document.getElementById(tab.dataset.target).classList.add("active");
  });
});

// ========================
// CLOCK + DATE
// ========================
function updateClock() {
  const now = new Date();
  const h = String(now.getHours()).padStart(2, "0");
  const m = String(now.getMinutes()).padStart(2, "0");
  const s = String(now.getSeconds()).padStart(2, "0");
  document.getElementById("time").textContent = `${h}:${m}:${s}`;

  const options = {
    weekday: "short",
    day: "2-digit",
    month: "short",
    year: "numeric",
  };
  document.getElementById("date").textContent = now.toLocaleDateString(
    "en-GB",
    options
  );
}
setInterval(updateClock, 1000);
updateClock();

// ========================
// STOPWATCH
// ========================
let stopwatchInterval,
  startTime,
  elapsed = 0,
  running = false;

function updateStopwatch() {
  const totalSeconds = Math.floor(elapsed / 1000);
  const hrs = String(Math.floor(totalSeconds / 3600)).padStart(2, "0");
  const mins = String(Math.floor((totalSeconds % 3600) / 60)).padStart(2, "0");
  const secs = String(totalSeconds % 60).padStart(2, "0");
  document.getElementById(
    "stopwatch-display"
  ).textContent = `${hrs}:${mins}:${secs}`;
}

document.getElementById("startStopwatch").addEventListener("click", () => {
  if (!running) {
    running = true;
    startTime = Date.now() - elapsed;
    stopwatchInterval = setInterval(() => {
      elapsed = Date.now() - startTime;
      updateStopwatch();
    }, 200);
  }
});

document.getElementById("stopStopwatch").addEventListener("click", () => {
  running = false;
  clearInterval(stopwatchInterval);
});

document.getElementById("resetStopwatch").addEventListener("click", () => {
  running = false;
  clearInterval(stopwatchInterval);
  elapsed = 0;
  updateStopwatch();
});

// ========================
// TIMER
// ========================
let timerInterval,
  timeLeft = 0,
  isRunning = false;
const timerInput = document.getElementById("timerInput");
const timerDisplay = document.getElementById("timer-display");

timerInput.addEventListener("input", () => {
  if (timerInput.value < 0) timerInput.value = 0;
});

function updateTimerDisplay() {
  const mins = String(Math.floor(timeLeft / 60)).padStart(2, "0");
  const secs = String(timeLeft % 60).padStart(2, "0");
  timerDisplay.textContent = `${mins}:${secs}`;
}

document.getElementById("startTimer").addEventListener("click", () => {
  if (isRunning) return;
  if (timeLeft === 0) {
    const input = parseInt(timerInput.value.trim(), 10);
    if (isNaN(input) || input <= 0) return;
    timeLeft = input;
  }
  isRunning = true;
  timerInterval = setInterval(() => {
    if (timeLeft > 0) {
      timeLeft--;
      updateTimerDisplay();
    } else {
      clearInterval(timerInterval);
      isRunning = false;
      timeLeft = 0;
      updateTimerDisplay();
    }
  }, 1000);
});

document.getElementById("stopTimer").addEventListener("click", () => {
  clearInterval(timerInterval);
  isRunning = false;
});

document.getElementById("resetTimer").addEventListener("click", () => {
  clearInterval(timerInterval);
  timeLeft = 0;
  isRunning = false;
  timerInput.value = "";
  updateTimerDisplay();
});

// ========================
// DARK / LIGHT MODE
// ========================
const themeSwitcher = document.getElementById("themeSwitcher");
const themeText = document.getElementById("themeText");

themeSwitcher.addEventListener("change", () => {
  document.body.classList.toggle("dark", themeSwitcher.checked);
  themeText.textContent = themeSwitcher.checked
    ? "🌙 Dark Mode"
    : "☀️ Light Mode";
});
